from scipy.stats import norm


def e_kernel(x,h):
    k = (1/h)*(3/4)*(1-((x/h)**2))
    k = k*(abs(x/h)<=1)
    return k


def gaussian_kernel(x,h):
    k = (1/h)*norm.pdf((x/h),0,1)
    return k


def binaryKernel(A,a): 
    # k(x_1,x_2) = x_1*x_2+(1-x_1)*(1-x_2)
    
    res = A.dot(a)
    res += (1 - A).dot(1 - a)
    return res